#!/bin/bash

set -e  # Exit immediately on error

echo "Updating package list and installing essential tools..."
apt-get update && apt-get install -y unzip tar

echo "Installing Ruby and development headers..."
apt-get update && apt-get install -y ruby ruby-dev

echo "Installing Ruby gems: dotenv and fpm..."
gem install dotenv -v 2.8.1
gem install fpm

echo "Installing gnupg and ca-certificates..."
apt-get update && apt-get install -y gnupg ca-certificates

echo "Adding Mono repository..."
apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 3FA7E0328081BFF6A14DA29AA6A19B38D3D831EF
echo "deb https://download.mono-project.com/repo/ubuntu stable-focal main" > /etc/apt/sources.list.d/mono-official-stable.list

echo "Installing full package set..."
apt-get update && apt-get install -y \
    build-essential \
    libwebkit2gtk-4.0-37 \
    mono-devel \
    mono-complete \
    git \
    automake \
    autoconf \
    libtool \
    g++ \
    manpages-fr-extra \
    gcc \
    libc6-dev \
    policykit-1 \
    libgtk2.0-0 \
    screen \
    uml-utilities \
    gtk-sharp2 \
    rpm \
    libarchive-tools \
    python3 \
    python3-pip \
    python3-setuptools \
    python3-dev \
    ruby \
    ruby-dev \
    lsb \
    device-tree-compiler \
    xvfb \
    x11-utils \
    xauth \
    lsof \
    libglib2.0-0 \
    libxslt1.1

echo "Cleaning up apt cache..."
rm -rf /var/lib/apt/lists/*

echo "Installing Python dependencies via pip..."
pip3 install GitPython requests PyYAML

echo "✅ Environment setup complete!"
